package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.ExamCultureData;
import org.msh.tb.entities.ExamCulture;
import org.msh.tb.entities.Tbunit;

/**
 * Created by rmemoria on 14/9/17.
 */
public class ExamCultureConsumer extends SyncDataConsumerImpl<ExamCultureData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ExamCultureData data) {
        ExamCulture exam = recoverEntity(ExamCulture.class, data.getServerId());


        moveLaboratoryExamData(data, exam);

        exam.setResult(data.getResult());
        exam.setComments(data.getComments());
        exam.setSampleType(data.getSampleType());
        exam.setDateRelease(data.getDateRelease());
        exam.setSampleNumber(data.getSampleNumber());
        exam.setLaboratory(getLaboratory(data.getLaboratoryId()));
        exam.setMethod(getFieldValue(data.getMethod()));
        exam.setNumberOfColonies(data.getNumberOfColonies());

        getEntityManager().persist(exam);

        return data.getServerId() == null ? exam.getId() : null;
    }
}
